/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world.entity.culling;

import club.sk1er.mods.core.gui.notification.Notifications;
import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.PatcherConfig;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;

public class EntityCulling {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final RenderManager renderManager = mc.func_175598_ae();
    private static final ConcurrentHashMap<UUID, OcclusionQuery> queries = new ConcurrentHashMap();
    private static final boolean SUPPORT_NEW_GL = GLContext.getCapabilities().OpenGL33;
    public static boolean shouldPerformCulling = false;

    public static boolean canRenderName(EntityLivingBase entity) {
        EntityPlayerSP player = EntityCulling.mc.field_71439_g;
        if (entity instanceof EntityPlayer && entity != player) {
            Team otherEntityTeam = entity.func_96124_cp();
            Team playerTeam = player.func_96124_cp();
            if (otherEntityTeam != null) {
                Team.EnumVisible teamVisibilityRule = otherEntityTeam.func_178770_i();
                switch (teamVisibilityRule) {
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return playerTeam == null || otherEntityTeam.func_142054_a(playerTeam);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return playerTeam == null || !otherEntityTeam.func_142054_a(playerTeam);
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && entity != EntityCulling.mc.func_175598_ae().field_78734_h && (entity instanceof EntityArmorStand || !entity.func_98034_c((EntityPlayer)player)) && entity.field_70153_n == null;
    }

    public static void drawSelectionBoundingBox(AxisAlignedBB b) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179141_d();
    }

    public static boolean renderItem(Entity stack) {
        return shouldPerformCulling && PatcherConfig.entityCulling && stack.field_70170_p == EntityCulling.mc.field_71439_g.field_70170_p && EntityCulling.checkEntity(stack);
    }

    private static int getQuery() {
        try {
            return GL15.glGenQueries();
        }
        catch (Throwable throwable) {
            Patcher.instance.getLogger().error("Failed to run GL15.glGenQueries(). User's computer is likely too old to support OpenGL 1.5, Entity Culling has been force disabled.", throwable);
            PatcherConfig.entityCulling = false;
            Patcher.instance.forceSaveConfig();
            Notifications.INSTANCE.pushNotification("Patcher", "Entity Culling has forcefully been disabled as your computer is too old and does not support the technology behind it.\nIf you believe this is a mistake, please contact us at discord.gg/sk1er");
            return 0;
        }
    }

    private static boolean checkEntity(Entity entity) {
        OcclusionQuery query = queries.computeIfAbsent(entity.func_110124_au(), OcclusionQuery::new);
        if (query.refresh) {
            query.nextQuery = EntityCulling.getQuery();
            query.refresh = false;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-EntityCulling.renderManager.field_78725_b), (double)(-EntityCulling.renderManager.field_78726_c), (double)(-EntityCulling.renderManager.field_78723_d));
            int mode = SUPPORT_NEW_GL ? 35887 : 35092;
            GL15.glBeginQuery((int)mode, (int)query.nextQuery);
            EntityCulling.drawSelectionBoundingBox(entity.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2));
            GL15.glEndQuery((int)mode);
            GlStateManager.func_179121_F();
        }
        return query.occluded;
    }

    @SubscribeEvent
    public void shouldRenderEntity(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (!PatcherConfig.entityCulling || !shouldPerformCulling) {
            return;
        }
        EntityLivingBase entity = event.entity;
        boolean armorstand = entity instanceof EntityArmorStand;
        if (entity == EntityCulling.mc.field_71439_g || entity.field_70170_p != EntityCulling.mc.field_71439_g.field_70170_p || PatcherConfig.checkArmorstandRules && armorstand && ((EntityArmorStand)entity).func_181026_s() || entity.func_98034_c((EntityPlayer)EntityCulling.mc.field_71439_g) && !armorstand) {
            return;
        }
        if (EntityCulling.checkEntity((Entity)entity)) {
            event.setCanceled(true);
            if (!EntityCulling.canRenderName(entity)) {
                return;
            }
            if (PatcherConfig.dontCullNametags && entity instanceof EntityPlayer || PatcherConfig.dontCullEntityNametags && !armorstand || PatcherConfig.dontCullArmourStandNametags && armorstand) {
                event.renderer.func_177067_a(entity, event.x, event.y, event.z);
            }
        }
    }

    @SubscribeEvent
    public void renderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(this::check);
    }

    private void check() {
        long delay = 0L;
        switch (PatcherConfig.cullingInterval) {
            case 0: {
                delay = 50L;
                break;
            }
            case 1: {
                delay = 25L;
                break;
            }
            case 2: {
                delay = 10L;
                break;
            }
        }
        long nanoTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        for (OcclusionQuery query : queries.values()) {
            long queryObject;
            if (query.nextQuery != 0 && (queryObject = (long)GL15.glGetQueryObjecti((int)query.nextQuery, (int)34919)) != 0L) {
                query.occluded = GL15.glGetQueryObjecti((int)query.nextQuery, (int)34918) == 0;
                GL15.glDeleteQueries((int)query.nextQuery);
                query.nextQuery = 0;
            }
            if (query.nextQuery != 0 || nanoTime - query.executionTime <= delay) continue;
            query.executionTime = nanoTime;
            query.refresh = true;
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        WorldClient theWorld = EntityCulling.mc.field_71441_e;
        if (theWorld == null) {
            return;
        }
        ArrayList<UUID> remove = new ArrayList<UUID>();
        block0: for (OcclusionQuery value : queries.values()) {
            for (Entity entity : theWorld.field_72996_f) {
                if (entity.func_110124_au() != value.uuid) continue;
                continue block0;
            }
            remove.add(value.uuid);
            if (value.nextQuery == 0) continue;
            GL15.glDeleteQueries((int)value.nextQuery);
        }
        for (UUID uuid : remove) {
            queries.remove(uuid);
        }
    }

    static class OcclusionQuery {
        private final UUID uuid;
        private int nextQuery;
        private boolean refresh = true;
        private boolean occluded;
        private long executionTime = 0L;

        public OcclusionQuery(UUID uuid) {
            this.uuid = uuid;
        }

        public UUID getUuid() {
            return this.uuid;
        }
    }
}

